'use client';

import type { InventoryData } from '@/components/dashboard/dashboard';
import {
  createContext,
  useContext,
  useState,
  type ReactNode,
  useMemo,
} from 'react';

type InventoryContextType = {
  inventoryData: InventoryData[];
  setInventoryData: (data: InventoryData[]) => void;
  csvString: string;
  setCsvString: (csv: string) => void;
  clearInventory: () => void;
  fileName: string;
  setFileName: (name: string) => void;
};

const InventoryContext = createContext<InventoryContextType | undefined>(
  undefined
);

export function InventoryProvider({ children }: { children: ReactNode }) {
  const [inventoryData, setInventoryData] = useState<InventoryData[]>([]);
  const [csvString, setCsvString] = useState<string>('');
  const [fileName, setFileName] = useState<string>('');

  const clearInventory = () => {
    setInventoryData([]);
    setCsvString('');
    setFileName('');
  };

  const value = useMemo(
    () => ({
      inventoryData,
      setInventoryData,
      csvString,
      setCsvString,
      fileName,
      setFileName,
      clearInventory,
    }),
    [inventoryData, csvString, fileName]
  );

  return (
    <InventoryContext.Provider value={value}>
      {children}
    </InventoryContext.Provider>
  );
}

export function useInventory() {
  const context = useContext(InventoryContext);
  if (context === undefined) {
    throw new Error('useInventory must be used within an InventoryProvider');
  }
  return context;
}
